/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.client.animation;

import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import net.minecraft.class_3532;
import net.minecraft.class_7179;
import org.joml.Vector3f;

public class Interpolations {
    public static final class_7179.class_7180 LINEAR = class_7179.class_7181.field_37884;
    public static final class_7179.class_7180 SPLINE = class_7179.class_7181.field_37885;
    public static final InterpolationCreator STEP = steps -> Interpolations.easing(Interpolations.step(Double.valueOf(steps)));
    public static final class_7179.class_7180 EASE_IN_QUADRATIC = Interpolations.easing(Interpolations.easeIn(Interpolations::quadratic));
    public static final class_7179.class_7180 EASE_OUT_QUADRATIC = Interpolations.easing(Interpolations.easeOut(Interpolations::quadratic));
    public static final class_7179.class_7180 EASE_IN_OUT_QUADRATIC = Interpolations.easing(Interpolations.easeInOut(Interpolations::quadratic));
    public static final class_7179.class_7180 EASE_IN_CUBIC = Interpolations.easing(Interpolations.easeIn(Interpolations::cubic));
    public static final class_7179.class_7180 EASE_OUT_CUBIC = Interpolations.easing(Interpolations.easeOut(Interpolations::cubic));
    public static final class_7179.class_7180 EASE_IN_OUT_CUBIC = Interpolations.easing(Interpolations.easeInOut(Interpolations::cubic));
    public static final class_7179.class_7180 EASE_IN_QUARTIC = Interpolations.easing(Interpolations.easeIn(Interpolations.pow(4.0)));
    public static final class_7179.class_7180 EASE_OUT_QUARTIC = Interpolations.easing(Interpolations.easeOut(Interpolations.pow(4.0)));
    public static final class_7179.class_7180 EASE_IN_OUT_QUARTIC = Interpolations.easing(Interpolations.easeInOut(Interpolations.pow(4.0)));
    public static final class_7179.class_7180 EASE_IN_QUINTIC = Interpolations.easing(Interpolations.easeIn(Interpolations.pow(5.0)));
    public static final class_7179.class_7180 EASE_OUT_QUINTIC = Interpolations.easing(Interpolations.easeOut(Interpolations.pow(5.0)));
    public static final class_7179.class_7180 EASE_IN_OUT_QUINTIC = Interpolations.easing(Interpolations.easeInOut(Interpolations.pow(5.0)));
    public static final class_7179.class_7180 EASE_IN_EXPO = Interpolations.easing(Interpolations.easeIn(Interpolations::exp));
    public static final class_7179.class_7180 EASE_OUT_EXPO = Interpolations.easing(Interpolations.easeOut(Interpolations::exp));
    public static final class_7179.class_7180 EASE_IN_OUT_EXPO = Interpolations.easing(Interpolations.easeInOut(Interpolations::exp));
    public static final class_7179.class_7180 EASE_IN_CIRCLE = Interpolations.easing(Interpolations.easeIn(Interpolations::circle));
    public static final class_7179.class_7180 EASE_OUT_CIRCLE = Interpolations.easing(Interpolations.easeOut(Interpolations::circle));
    public static final class_7179.class_7180 EASE_IN_OUT_CIRCLE = Interpolations.easing(Interpolations.easeInOut(Interpolations::circle));
    public static final InterpolationCreator EASE_IN_BACK = overshoot -> Interpolations.easing(Interpolations.easeIn(Interpolations.back(Double.valueOf(overshoot))));
    public static final InterpolationCreator EASE_OUT_BACK = overshoot -> Interpolations.easing(Interpolations.easeOut(Interpolations.back(Double.valueOf(overshoot))));
    public static final InterpolationCreator EASE_IN_OUT_BACK = overshoot -> Interpolations.easing(Interpolations.easeInOut(Interpolations.back(Double.valueOf(overshoot))));
    public static final InterpolationCreator EASE_IN_BOUNCE = bounciness -> Interpolations.easing(Interpolations.easeIn(Interpolations.bounce(Double.valueOf(bounciness))));
    public static final InterpolationCreator EASE_OUT_BOUNCE = bounciness -> Interpolations.easing(Interpolations.easeOut(Interpolations.bounce(Double.valueOf(bounciness))));
    public static final InterpolationCreator EASE_IN_OUT_BOUNCE = bounciness -> Interpolations.easing(Interpolations.easeInOut(Interpolations.bounce(Double.valueOf(bounciness))));
    public static final class_7179.class_7180 EASE_IN_SINE = Interpolations.easing(Interpolations.easeIn(Interpolations::sine));
    public static final class_7179.class_7180 EASE_OUT_SINE = Interpolations.easing(Interpolations.easeOut(Interpolations::sine));
    public static final class_7179.class_7180 EASE_IN_OUT_SINE = Interpolations.easing(Interpolations.easeInOut(Interpolations::sine));
    public static final InterpolationCreator EASE_IN_ELASTIC = bounciness -> Interpolations.easing(Interpolations.easeIn(Interpolations.elastic(Double.valueOf(bounciness))));
    public static final InterpolationCreator EASE_OUT_ELASTIC = bounciness -> Interpolations.easing(Interpolations.easeOut(Interpolations.elastic(Double.valueOf(bounciness))));
    public static final InterpolationCreator EASE_IN_OUT_ELASTIC = bounciness -> Interpolations.easing(Interpolations.easeInOut(Interpolations.elastic(Double.valueOf(bounciness))));

    private static class_7179.class_7180 easing(Double2DoubleFunction easing) {
        return (output, delta, keyframes, currentFrame, targetFrame, strength) -> {
            Vector3f vector3f = keyframes[currentFrame].comp_601();
            Vector3f vector3f2 = keyframes[targetFrame].comp_601();
            double eased = delta <= 0.0f ? 0.0 : (delta >= 1.0f ? 1.0 : (Double)easing.apply((Object)delta));
            output.set(class_3532.method_16436((double)eased, (double)vector3f.x(), (double)vector3f2.x()), class_3532.method_16436((double)eased, (double)vector3f.y(), (double)vector3f2.y()), class_3532.method_16436((double)eased, (double)vector3f.z(), (double)vector3f2.z()));
            return output;
        };
    }

    static Double2DoubleFunction easeIn(Double2DoubleFunction function) {
        return function;
    }

    static Double2DoubleFunction easeOut(Double2DoubleFunction function) {
        return time -> 1.0 - (Double)function.apply((Object)(1.0 - time));
    }

    static Double2DoubleFunction easeInOut(Double2DoubleFunction function) {
        return time -> {
            if (time < 0.5) {
                return (Double)function.apply((Object)(time * 2.0)) / 2.0;
            }
            return 1.0 - (Double)function.apply((Object)((1.0 - time) * 2.0)) / 2.0;
        };
    }

    static double quadratic(double n) {
        return n * n;
    }

    static double cubic(double n) {
        return n * n * n;
    }

    static double sine(double n) {
        return 1.0 - Math.cos(n * Math.PI / 2.0);
    }

    static double circle(double n) {
        return 1.0 - Math.sqrt(1.0 - n * n);
    }

    static double exp(double n) {
        return Math.pow(2.0, 10.0 * (n - 1.0));
    }

    static Double2DoubleFunction elastic(Double n) {
        double n2 = n == null ? 1.0 : n;
        return t -> 1.0 - Math.pow(Math.cos(t * Math.PI / 2.0), 3.0) * Math.cos(t * n2 * Math.PI);
    }

    static Double2DoubleFunction bounce(Double n) {
        double n2 = n == null ? 0.5 : n;
        Double2DoubleFunction one = x -> 7.5625 * x * x;
        Double2DoubleFunction two = x -> 30.25 * n2 * Math.pow(x - 0.5454545617103577, 2.0) + 1.0 - n2;
        Double2DoubleFunction three = x -> 121.0 * n2 * n2 * Math.pow(x - 0.8181818127632141, 2.0) + 1.0 - n2 * n2;
        Double2DoubleFunction four = x -> 484.0 * n2 * n2 * n2 * Math.pow(x - 0.9545454382896423, 2.0) + 1.0 - n2 * n2 * n2;
        return t -> Math.min(Math.min((Double)one.apply((Object)t), (Double)two.apply((Object)t)), Math.min((Double)three.apply((Object)t), (Double)four.apply((Object)t)));
    }

    static Double2DoubleFunction back(Double n) {
        double n2 = n == null ? 1.70158 : n * 1.70158;
        return t -> t * t * ((n2 + 1.0) * t - n2);
    }

    static Double2DoubleFunction pow(double n) {
        return t -> Math.pow(t, n);
    }

    static Double2DoubleFunction step(Double n) {
        double n2;
        double d = n2 = n == null ? 2.0 : n;
        if (n2 < 2.0) {
            throw new IllegalArgumentException("Steps must be >= 2, got: " + n2);
        }
        int steps = (int)n2;
        return t -> {
            double d;
            double result = 0.0;
            if (t < 0.0) {
                return result;
            }
            double stepLength = 1.0 / (double)steps;
            result = (double)(steps - 1) * stepLength;
            if (t > d) {
                return result;
            }
            int leftBorderIndex = 0;
            int rightBorderIndex = steps - 1;
            while (rightBorderIndex - leftBorderIndex != 1) {
                int testIndex = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
                if (t >= (double)testIndex * stepLength) {
                    leftBorderIndex = testIndex;
                    continue;
                }
                rightBorderIndex = testIndex;
            }
            return (double)leftBorderIndex * stepLength;
        };
    }

    public static interface InterpolationCreator {
        public class_7179.class_7180 configure(float var1);
    }
}

